//
//  GS1DataBar.m
//  22222222222222
//
//  Created by liangchenying on 12-4-9.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "GS1DataBar.h"
#import "ButtonPullDownPrepare.h"
#import "ButtonPullDownRealize.h"

@interface GS1DataBar()
@property (nonatomic, retain) POSSDK	 *pos_sdk;
@end

@implementation GS1DataBar
@synthesize Back;
@synthesize GS1DataBarData;
@synthesize DataLabel = _DataLabel;
@synthesize GS1DataBarBarcodeHeight;
@synthesize BarcodeheightLabel = _BarcodeheightLabel;
@synthesize BarcodeTypeButton;
@synthesize BarcodeType = _BarcodeType;
@synthesize BasicElementWidthButton;
@synthesize ElementWidth = _ElementWidth;
@synthesize BasicElementHeightButton;
@synthesize ElementHeight = _ElementHeight;
@synthesize SeparatorHeightButton;
@synthesize SeparatorHeight = _SeparatorHeight;
@synthesize HRIButton;
@synthesize HRI = _HRI;
@synthesize AIButton;
@synthesize AI = _AI;
@synthesize Cut;
@synthesize GS1DataBarPrint;
@synthesize SegmentNumber = _SegmentNumber;
@synthesize SegmentNumberButton = _SegmentNumberButton;

@synthesize pos_sdk		               = _pos_sdk;

@synthesize array_BarcodeType	       = _array_BarcodeType;
@synthesize array_BasicElementWidth    = _array_BasicElementWidth;
@synthesize array_BasicElementHeight   = _array_BasicElementHeight;
@synthesize array_SeparatorHeight	   = _array_SeparatorHeight;
@synthesize array_SegmentNumber        = _array_SegmentNumber;
@synthesize array_HRI	               = _array_HRI;
@synthesize array_AI	               = _array_AI;

@synthesize selectedBarcodeType	       = _selectedBarcodeType;
@synthesize selectedBasicElementWidth  = _selectedBasicElementWidth;
@synthesize selectedBasicElementHeight = _selectedBasicElementHeight;
@synthesize selectedSeparatorHeight	   = _selectedSeparatorHeight;
@synthesize selectedSegmentNumber      = _selectedSegmentNumber;
@synthesize selectedHRI	               = _selectedHRI;
@synthesize selectedAI	               = _selectedAI;

- (NSMutableArray*)array_BarcodeType
{
    if(_array_BarcodeType  == nil)
    {
        _array_BarcodeType = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_BarcodeType;
}

- (NSMutableArray*)array_BasicElementWidth
{
    if(_array_BasicElementWidth  == nil)
    {
        _array_BasicElementWidth = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_BasicElementWidth;
}

- (NSMutableArray*)array_BasicElementHeight
{
    if(_array_BasicElementHeight  == nil)
    {
        _array_BasicElementHeight = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_BasicElementHeight;
}

- (NSMutableArray*)array_SeparatorHeight
{
    if(_array_SeparatorHeight  == nil)
    {
        _array_SeparatorHeight = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_SeparatorHeight;
}

- (NSMutableArray*)array_SegmentNumber
{
    if(_array_SegmentNumber  == nil)
    {
        _array_SegmentNumber = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_SegmentNumber;
}

- (NSMutableArray*)array_HRI
{
    if(_array_HRI  == nil)
    {
        _array_HRI = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_HRI;
}

- (NSMutableArray*)array_AI
{
    if(_array_AI  == nil)
    {
        _array_AI = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_AI;
}



- (id)initWithNibNamePOSSDK:(NSString *)nibNameOrNil pos_sdk:(POSSDK*)pos_sdk bundle:(NSBundle *)nibBundleOrNil
{
    self.pos_sdk = pos_sdk;
    return [self initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
}

- (NSInteger)NSArrayToInt:(NSMutableArray *)Array  Index:(NSInteger)Index
{
    NSInteger INT;
    NSString *String = nil;
    String = [Array objectAtIndex:Index];
    INT = [String intValue];
 
    return INT;
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) 
    {
        //**************************************************************************************************
        //Add object for array_BarcodeType
        [self.array_BarcodeType addObject:@"Omnidirectional"];
        [self.array_BarcodeType addObject:@"Truncated"];
        [self.array_BarcodeType addObject:@"Stacked"];
        [self.array_BarcodeType addObject:@"Stacked Omnidirectional"];
        [self.array_BarcodeType addObject:@"Limited"]; 
        [self.array_BarcodeType addObject:@"Expanded"];
        [self.array_BarcodeType addObject:@"Expanded Stacked"];
  
        //**************************************************************************************************
        //Add object for array_BasicElementWidth
        [self.array_BasicElementWidth addObject:@"1"];
        [self.array_BasicElementWidth addObject:@"2"];
        [self.array_BasicElementWidth addObject:@"3"];
        [self.array_BasicElementWidth addObject:@"4"];
        [self.array_BasicElementWidth addObject:@"5"]; 
        [self.array_BasicElementWidth addObject:@"6"];
  
        //**************************************************************************************************
        //Add object for array_BasicElementHeight
        [self.array_BasicElementHeight addObject:@"1"];
        [self.array_BasicElementHeight addObject:@"2"];
        [self.array_BasicElementHeight addObject:@"3"];
        [self.array_BasicElementHeight addObject:@"4"];
        [self.array_BasicElementHeight addObject:@"5"]; 
        [self.array_BasicElementHeight addObject:@"6"];
        [self.array_BasicElementHeight addObject:@"7"];
        [self.array_BasicElementHeight addObject:@"8"];
        [self.array_BasicElementHeight addObject:@"9"];
        [self.array_BasicElementHeight addObject:@"10"];
 
        //**************************************************************************************************
        //Add object for array_SeparatorHeight
        [self.array_SeparatorHeight addObject:@"1"];
        [self.array_SeparatorHeight addObject:@"2"];
        [self.array_SeparatorHeight addObject:@"3"];
        [self.array_SeparatorHeight addObject:@"4"];
        [self.array_SeparatorHeight addObject:@"5"]; 
        [self.array_SeparatorHeight addObject:@"6"];
        [self.array_SeparatorHeight addObject:@"7"];
        [self.array_SeparatorHeight addObject:@"8"];
        [self.array_SeparatorHeight addObject:@"9"];
        [self.array_SeparatorHeight addObject:@"10"];
  
        //**************************************************************************************************
        //Add object for array_SegmentNumber
        [self.array_SegmentNumber addObject:@"2"];
        [self.array_SegmentNumber addObject:@"3"];
        [self.array_SegmentNumber addObject:@"4"];
        [self.array_SegmentNumber addObject:@"5"]; 
        [self.array_SegmentNumber addObject:@"6"];
        [self.array_SegmentNumber addObject:@"7"];
        [self.array_SegmentNumber addObject:@"8"];
        [self.array_SegmentNumber addObject:@"9"];
        [self.array_SegmentNumber addObject:@"10"];
        [self.array_SegmentNumber addObject:@"11"];
        [self.array_SegmentNumber addObject:@"12"];
        [self.array_SegmentNumber addObject:@"13"];
        [self.array_SegmentNumber addObject:@"14"];
        [self.array_SegmentNumber addObject:@"15"]; 
        [self.array_SegmentNumber addObject:@"16"];
        [self.array_SegmentNumber addObject:@"17"];
        [self.array_SegmentNumber addObject:@"18"];
        [self.array_SegmentNumber addObject:@"19"];
        [self.array_SegmentNumber addObject:@"20"];

        //**************************************************************************************************
        //Add object for array_HRI
        [self.array_HRI addObject:@"DataBar And 2D"];
        [self.array_HRI addObject:@"Only DataBar"];
        [self.array_HRI addObject:@"Only 2D"];
        [self.array_HRI addObject:@"NoHri"];
                
        //**************************************************************************************************
        //Add object for array_AI
        [self.array_AI addObject:@"0"];
        [self.array_AI addObject:@"1"];
    }
    return self;
}

- (void)didReceiveMemoryWarning
{
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.selectedBarcodeType        = 0;
    self.selectedBasicElementWidth  = 2;
    self.selectedBasicElementHeight = 3;
    self.selectedSegmentNumber      = 0;
    self.selectedSeparatorHeight    = 0;
    self.selectedHRI                = 0;
    self.selectedAI                 = 1;

    [self.GS1DataBarData          setDelegate:self];
    [self.GS1DataBarBarcodeHeight setDelegate:self];
    
    [self.BarcodeTypeButton        setTitle:@"Omnidirectional" forState:UIControlStateNormal];
    [self.BasicElementWidthButton  setTitle:@"3" forState:UIControlStateNormal];
    [self.BasicElementWidthButton  setEnabled:1];
    [self.BasicElementHeightButton setTitle:@"4" forState:UIControlStateNormal];
    [self.SegmentNumberButton      setTitle:@"2" forState:UIControlStateNormal];
    [self.SeparatorHeightButton    setTitle:@"1" forState:UIControlStateNormal];
    [self.HRIButton                setTitle:@"DataBar And 2D" forState:UIControlStateNormal];
    [self.AIButton                 setTitle:@"1" forState:UIControlStateNormal];
    
    [self.GS1DataBarData           setText:@"0123456789012"];
    [self.GS1DataBarBarcodeHeight  setText:@"100"];
    
    ButtonEnableAndAlpha(self.SeparatorHeightButton, 0, 0);
    ButtonEnableAndAlpha(self.SeparatorHeight, 0, 0);
    
    ButtonEnableAndAlpha(self.SegmentNumberButton, 0, 0);
    ButtonEnableAndAlpha(self.SegmentNumber, 0, 0);
    
    self.GS1DataBarData.frame           = CGRectMake(64,50,246,31);
    self.DataLabel.frame                = CGRectMake(0,50,55,31);
    
    self.GS1DataBarBarcodeHeight.frame  = CGRectMake(190,140,120,31);
    self.BarcodeheightLabel.frame       = CGRectMake(0,140,172,31);
    
    self.BarcodeTypeButton.frame        = CGRectMake(120,95,190,31);
    self.BarcodeType.frame              = CGRectMake(0,95,110,31);
    
    self.BasicElementWidthButton.frame  = CGRectMake(190,185,120,31);
    self.ElementWidth.frame             = CGRectMake(0,185,172,31);
    
    self.BasicElementHeightButton.frame = CGRectMake(190,230,120,31);
    self.ElementHeight.frame            = CGRectMake(0,230,172,31);    
    
    self.HRIButton.frame                = CGRectMake(190,275,120,31);
    self.HRI.frame                      = CGRectMake(0,275,172,31);
    
    self.AIButton.frame                 = CGRectMake(190,320,120,31);
    self.AI.frame                       = CGRectMake(0,320,172,31);
}

- (void)viewDidUnload
{
    [self setBack:nil];
    [self setGS1DataBarData:nil];
    [self setBarcodeTypeButton:nil];
    [self setBasicElementWidthButton:nil];
    [self setGS1DataBarBarcodeHeight:nil];
    [self setBasicElementHeightButton:nil];
    [self setSeparatorHeightButton:nil];

    [self setHRIButton:nil];
    [self setAIButton:nil];
    [self setCut:nil];
    [self setGS1DataBarPrint:nil];
    [self setSeparatorHeight:nil];

    [self setDataLabel:nil];
    [self setBarcodeheightLabel:nil];
    [self setBarcodeType:nil];
    [self setElementWidth:nil];
    [self setElementHeight:nil];
    [self setHRI:nil];
    [self setAI:nil];
    
    [self setSegmentNumber:nil];
    [self setSegmentNumberButton:nil];
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

//**************************************************************************************************
//Return to the main View by press the button "Back"
- (IBAction)Back:(id)sender 
{
     [self dismissViewControllerAnimated:YES completion:nil];
}

//**************************************************************************************************
//Exit the keyboard by clicking "return"
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    if ([string isEqualToString:@"\n"])
    {
        [self.GS1DataBarData          resignFirstResponder];
        [self.GS1DataBarBarcodeHeight resignFirstResponder];
        return NO;
    } 
return YES;
}



//**************************************************************************************************
//Get Barcode Type Index
- (IBAction)selectBarcodeType:(id)sender 
{
	PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedBarcodeType = selectedIndex; 
        
        if (self.selectedBarcodeType== 6)
        {
            //**************************************************************************************************
            //Set Controllers enable to use or not
            ButtonEnableAndAlpha(self.SegmentNumberButton, 1, 1);
            ButtonEnableAndAlpha(self.SeparatorHeightButton, 1, 1); 
            
            ButtonEnableAndAlpha(self.SeparatorHeight, 1, 1); 
            ButtonEnableAndAlpha(self.SegmentNumber, 1, 1);
            
			//**************************************************************************************************
            //Set the position of Controllers
            self.GS1DataBarData.frame           = CGRectMake(64,20,246,31);
            self.DataLabel.frame                = CGRectMake(0,20,55,31);
            
            self.GS1DataBarBarcodeHeight.frame  = CGRectMake(190,104,120,31);
            self.BarcodeheightLabel.frame       = CGRectMake(0,104,172,31);
            
            self.BarcodeTypeButton.frame        = CGRectMake(120,62,190,31);
            self.BarcodeType.frame              = CGRectMake(0,62,110,31);
            
            self.BasicElementWidthButton.frame  = CGRectMake(190,146,120,31);
            self.ElementWidth.frame             = CGRectMake(0,146,172,31);
			
			self.SegmentNumberButton.frame      = CGRectMake(190,188,120,31);
            self.SegmentNumber.frame            = CGRectMake(0,188,172,31);
            
            self.SeparatorHeightButton.frame    = CGRectMake(190,230,120,31);
            self.SeparatorHeight.frame          = CGRectMake(0,230,172,21);
			
			self.BasicElementHeightButton.frame = CGRectMake(190,272,120,31);
            self.ElementHeight.frame            = CGRectMake(0,272,172,31);
            
            self.HRIButton.frame                = CGRectMake(190,314,120,31);
            self.HRI.frame                      = CGRectMake(0,314,172,31);
            
            self.AIButton.frame                 = CGRectMake(190,356,120,31);
            self.AI.frame                       = CGRectMake(0,356,172,31);
        }
        else if (self.selectedBarcodeType== 2 || self.selectedBarcodeType== 3)
        {
            ButtonEnableAndAlpha(self.SeparatorHeightButton, 1, 1); 
            ButtonEnableAndAlpha(self.SeparatorHeight, 1, 1); 
            
            ButtonEnableAndAlpha(self.SegmentNumberButton, 0, 0);
            ButtonEnableAndAlpha(self.SegmentNumber, 0, 0);
            
            self.GS1DataBarData.frame           = CGRectMake(64,30,246,31);
            self.DataLabel.frame                = CGRectMake(0,30,55,31);
            
            self.GS1DataBarBarcodeHeight.frame  = CGRectMake(190,120,120,31);
            self.BarcodeheightLabel.frame       = CGRectMake(0,120,172,31);
            
            self.BarcodeTypeButton.frame        = CGRectMake(120,75,190,31);
            self.BarcodeType.frame              = CGRectMake(0,75,110,31);
            
            self.BasicElementWidthButton.frame  = CGRectMake(190,165,120,31);
            self.ElementWidth.frame             = CGRectMake(0,165,172,31);
            
            self.SeparatorHeightButton.frame    = CGRectMake(190,210,120,31);
            self.SeparatorHeight.frame          = CGRectMake(0,210,172,21);
			
			self.BasicElementHeightButton.frame = CGRectMake(190,255,120,31);
            self.ElementHeight.frame            = CGRectMake(0,255,172,31);
            
            self.HRIButton.frame                = CGRectMake(190,300,120,31);
            self.HRI.frame                      = CGRectMake(0,300,172,31);
            
            self.AIButton.frame                 = CGRectMake(190,345,120,31);
            self.AI.frame                       = CGRectMake(0,345,172,31);
        }
        else
        {
            ButtonEnableAndAlpha(self.SeparatorHeightButton, 0, 0); 
            ButtonEnableAndAlpha(self.SegmentNumberButton, 0, 0);
            
            ButtonEnableAndAlpha(self.SeparatorHeight, 0, 0); 
            ButtonEnableAndAlpha(self.SegmentNumber, 0, 0);
            
            self.GS1DataBarData.frame           = CGRectMake(64,50,246,31);
            self.DataLabel.frame                = CGRectMake(0,50,55,31);
            
            self.GS1DataBarBarcodeHeight.frame  = CGRectMake(190,140,120,31);
            self.BarcodeheightLabel.frame       = CGRectMake(0,140,172,31);
            
            self.BarcodeTypeButton.frame        = CGRectMake(120,95,190,31);
            self.BarcodeType.frame              = CGRectMake(0,95,110,31);
            
            self.BasicElementWidthButton.frame  = CGRectMake(190,185,120,31);
            self.ElementWidth.frame             = CGRectMake(0,185,172,31);
            
            self.BasicElementHeightButton.frame = CGRectMake(190,230,120,31);
            self.ElementHeight.frame            = CGRectMake(0,230,172,31);
            
            
            self.HRIButton.frame                = CGRectMake(190,275,120,31);
            self.HRI.frame                      = CGRectMake(0,275,172,31);
            
            self.AIButton.frame                 = CGRectMake(190,320,120,31);
            self.AI.frame                       = CGRectMake(0,320,172,31);
        }
 
        [self.BarcodeTypeButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Barcode Type" Sheet:self.array_BarcodeType Selected:self.selectedBarcodeType DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Select Basic Element Width(1-6) Index
- (IBAction)selectBasicElementWidth:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedBasicElementWidth = selectedIndex;  
        [self.BasicElementWidthButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };

    [ButtonPullDownRealize sheetPickerTitle:@"Basic Element Width" Sheet:self.array_BasicElementWidth Selected:self.selectedBasicElementWidth DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Select Basic Element Height(1-10) Index
- (IBAction)selectBasicElementHeight:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedBasicElementHeight = selectedIndex;  
        [self.BasicElementHeightButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Basic Element Height" Sheet:self.array_BasicElementHeight Selected:self.selectedBasicElementHeight DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Select Separator Height(1-10) Index
- (IBAction)selectSeparatorHeight:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedSeparatorHeight = selectedIndex;  
        [self.SeparatorHeightButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Separator Height" Sheet:self.array_SeparatorHeight Selected:self.selectedSeparatorHeight DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Select Segment Number(2-20) Index
- (IBAction)selectSegmentNumber:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedSegmentNumber = selectedIndex;  
        [self.SegmentNumberButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Segment Number" Sheet:self.array_SegmentNumber Selected:self.selectedSegmentNumber DoneButton:done CancelButton:cancel Action:sender]; 
}


//**************************************************************************************************
//Select HRI Index
- (IBAction)selectHRI:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedHRI = selectedIndex;  
        [self.HRIButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"HRI" Sheet:self.array_HRI Selected:self.selectedHRI DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Select AI Index
- (IBAction)selectAI:(id)sender
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedAI = selectedIndex;  
        [self.AIButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"AI" Sheet:self.array_AI Selected:self.selectedAI DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Cut paper
- (IBAction)Cut:(id)sender 
{
    SInt32 error_code = SUCCESS;
    
    error_code = [self.pos_sdk systemCutPaper:CutPartAfterFeed FeedDistance:80];
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
    }

ExitLine:
    return;
}

//**************************************************************************************************
//Print GS1 DataBar
- (IBAction)GS1DataBarPrint:(id)sender 
{
    //Initialize
    SInt32 error_code       = SUCCESS;
    SInt32 barcode_type     = 0;
    SInt32 barcode_height   = 0;
    SInt32 element_width    = 0;
    SInt32 element_height   = 0;
    SInt32 separator_height = 0;
    SInt32 segment_number   = 0;
    SInt32 hri              = 0;
    SInt32 i                = 0;
    NSData *textNSData      = nil;	

    //**************************************************************************************************
    //If Data == nil ,barcode cannot be printed.
    JudgeParamNil(GS1DataBarData, @"Data == nil,Please input data");
    
    //**************************************************************************************************
    //Get Data
    textNSData       = [self.GS1DataBarData.text dataUsingEncoding:NSUTF8StringEncoding];
    
    //**************************************************************************************************
    //If Barcode Height == nil ,barcode cannot be printed.
    JudgeParamNil(GS1DataBarBarcodeHeight, @"Barcode Height == nil,Please input Height 2-250");
    
    //**************************************************************************************************
    //Barcode Height must be digit.
    JudgeParamDigitOrNot(GS1DataBarBarcodeHeight, @"ERROR Barcode height.It must be 2-250");
    
   //**************************************************************************************************
    //Barcode Height must be 2-250.
    barcode_height   = [self.GS1DataBarBarcodeHeight.text intValue];
    JudgeParamRange(barcode_height, 2, 250, @"ERROR Barcode height.It must be 2-250");
    
    element_width    = [self NSArrayToInt:self.array_BasicElementWidth Index:self.selectedBasicElementWidth];
    element_height   = [self NSArrayToInt:self.array_BasicElementHeight Index:self.selectedBasicElementHeight];
	
	

	//**************************************************************************************************
    //Get barcode type
	if ([[self.BarcodeTypeButton currentTitle]  isEqualToString: @"Omnidirectional"]) 
    {
        barcode_type = GS1DataBar_Omnidirectional;
    }
    else if ([[self.BarcodeTypeButton currentTitle] isEqualToString:@"Truncated"]) 
    {
        barcode_type = GS1DataBar_Truncated;
    }
	else if ([[self.BarcodeTypeButton currentTitle] isEqualToString: @"Stacked"]) 
    {
        barcode_type = GS1DataBar_Stacked;
    }
	else if ([[self.BarcodeTypeButton currentTitle] isEqualToString: @"Stacked Omnidirectional"]) 
    {
        barcode_type = GS1DataBar_StackedOmnidirectional;
    }
	else if ([[self.BarcodeTypeButton currentTitle] isEqualToString: @"Limited"]) 
    {
        barcode_type = GS1DataBar_Limited;
    }
	else if ([[self.BarcodeTypeButton currentTitle] isEqualToString: @"Expanded"]) 
    {
        barcode_type = GS1DataBar_Expanded;
    }
	else if ([[self.BarcodeTypeButton currentTitle] isEqualToString: @"Expanded Stacked"]) 
    {
        barcode_type = GS1DataBar_ExpandedStacked;
    }

    if (barcode_type == GS1DataBar_ExpandedStacked)
    {
        separator_height = [self NSArrayToInt:self.array_SeparatorHeight Index:self.selectedSeparatorHeight];
        segment_number   = [self NSArrayToInt:self.array_SegmentNumber Index:self.selectedSegmentNumber];        
    }
    else if (barcode_type == GS1DataBar_Stacked ||  barcode_type == GS1DataBar_StackedOmnidirectional)
    {
        separator_height = [self NSArrayToInt:self.array_SeparatorHeight Index:self.selectedSeparatorHeight];
        segment_number   = 2;     
    }
    else
    {
        separator_height = 1;
        segment_number   = 2;      
    }

	//**************************************************************************************************
    //Get HRI
    if(self.selectedHRI == 0)          hri = DataBarAnd2DHri;
    else if(self.selectedHRI == 1)     hri = OnlyDataBarHri;
    else if(self.selectedHRI == 2)     hri = Only2DHri;
    else if(self.selectedHRI == 3)     hri = NoHri;
      
    //**************************************************************************************************
    //Print barcode
    error_code = [self.pos_sdk barcodePrintGS1DataBar:textNSData BarcodeType:barcode_type BasicElementWidth:element_width BarcodeHeight:barcode_height SegmentNumber:segment_number SeparatorHeight:separator_height BasicElementHeight:element_height HRI:hri UseAI:self.selectedAI];
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
    }

ExitLine:
    return;
}

- (void)dealloc 
{
    [self.Back release];
    [self.GS1DataBarData release];
    [self.BarcodeTypeButton release];
    [self.BasicElementWidthButton release];
    [self.GS1DataBarBarcodeHeight release];
    [self.BasicElementHeightButton release];
    [self.SeparatorHeightButton release];
    [self.HRIButton release];
    [self.AIButton release];
    [self.Cut release];
    [self.GS1DataBarPrint release];
    [self.SeparatorHeight release];
    [self.DataLabel release];
    [self.BarcodeheightLabel release];
    [self.BarcodeType release];
    [self.ElementWidth release];
    [self.ElementHeight release];
    [self.HRI release];
    [self.AI release];    
    [self.SegmentNumber release];
    [self.SegmentNumberButton release];
    
    [self.array_BarcodeType release];
    [self.array_BasicElementWidth release];
    [self.array_BasicElementHeight release];
    [self.array_SeparatorHeight release];
    [self.array_SegmentNumber release];
    [self.array_HRI release];
    [self.array_AI release];

    [super dealloc];
}
@end
